﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage

    Private Const RADIUS As Integer = 200

    Public Sub New()
        InitializeComponent()

        Dim writeableBitmap As New WriteableBitmap(2 * RADIUS, 2 * RADIUS)

        For y = 0 To writeableBitmap.PixelWidth - 1
            For x = 0 To writeableBitmap.PixelHeight - 1
                If Math.Sqrt(Math.Pow(x - RADIUS, 2) + Math.Pow(y - RADIUS, 2)) < RADIUS Then
                    Dim angle = Math.Atan2(y - RADIUS, x - RADIUS)
                    Dim R = CInt(CByte(255 * Math.Abs(angle) / Math.PI))
                    Dim B = CInt(CByte(255 - R))
                    Dim color = 255 << 24 Or R << 16 Or B
                    writeableBitmap.Pixels(y * writeableBitmap.PixelWidth + x) = color
                End If
            Next x
        Next y

        writeableBitmap.Invalidate()
        img.Source = writeableBitmap
    End Sub
End Class
